###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_pgp_desktop_detect_win.nasl 789 2009-01-02 13:40:29Z jan $
#
# PGP Desktop Version Detection (Windows)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net 
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800215);
  script_version("$Revision: 1.0 $");
  script_name("PGP Desktop Version Detection (Windows)");
  desc = "

  Overview: The script detects the installed PGP Desktop Version and saves
  the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Check for PGP Desktop version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\PGP Corporation\PGP")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if("PGP Desktop" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    pgpdeskVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(pgpdeskVer != NULL){
      set_kb_item(name:"PGPDesktop/Win/Ver", value:pgpdeskVer);
    }
    exit(0);
  }
}
