###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_pegasus_mail_detect.nasl 5592 2009-11-05 13:25:37Z nov $
#
# Pegasus Mail Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800969);
  script_version("$Revision: 1.0 $");
  script_name("Pegasus Mail Version Detection");
  desc = "
  Overview: This script retrieves the installed version of Pegasus Mail and
  saves the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_summary("Set the version of Pegasus Mail in KB");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Pegasus Mail";
pmailName = registry_get_sz(key:key, item:"DisplayName");
if("Pegasus Mail" >< pmailName)
{
  pmailPath = registry_get_sz(key:key, item:"UninstallString");
  if(pmailPath)
  {
    pmailPath =  eregmatch(pattern:"^(.+(exe|EXE))(.*)?$", string:pmailPath);
    if(pmailPath[1] != NULL)
    {
      pmailPath =  pmailPath[1] - "DESETUP.EXE" - "DeSetup.exe" + "winpm-32.exe";
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:pmailPath);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:pmailPath);

      pmailVer = GetVer(file:file, share:share);
      if(!isnull(pmailVer)){
          set_kb_item(name:"Pegasus/Mail/Ver", value:pmailVer);
      }
    }
  }
}
