###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_peazip_code_exec_vuln.nasl 3193 2009-07-02 09:55:29Z jul $
#
# PeaZIP Remote Code Execution Vulnerability (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800593);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2261");
  script_name("PeaZIP Remote Code Execution Vulnerability (Win)");
  desc = "

  Overview: This host is installed with PeaZIP and is prone to Remote
  Code Execution vulnerability.

  Vulnerability Insight:
  The flaw is caused due to insufficient sanitation of input data while
  processing the names of archived files. 
  
  Impact:
  Successful exploitation will let the attacker to exectue arbitrary code on
  the affected system via files containing shell metacharacters and commands 
  contained in a ZIP archive.

  Affected Software/OS:
  PeaZIP version 2.6.1 and prior on Windows.

  Fix:
  Update to PeaZIP version 2.6.2
  http://sourceforge.net/projects/peazip/files/

  References:
  http://www.vulnaware.com/?p=16018
  http://secunia.com/advisories/35352/

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of PeaZIP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_peazip_detect_win.nasl");
  script_require_keys("PeaZIP/Win/Ver");
  exit(0);
}


include("version_func.inc");

version = get_kb_item("PeaZIP/Win/Ver");
if(!version){
  exit(0);
}

# Grep for PeaZIP version 2.6.1 and prior
if(version_is_less_equal(version:version, test_version:"2.6.1")){
  security_hole(0);
}
