###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openssl_sslkss_dos_vuln_win.nasl 7599 2010-03-10 13:10:29Z mar $
#
# OpenSSL 'kssl_keytab_is_available()' Denial Of Service Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800490);
  script_version("$Revision: 6941 $: 1.0");
  script_cve_id("CVE-2010-0433");
  script_name("OpenSSL 'kssl_keytab_is_available()' Denial Of Service Vulnerability (Win)");
  desc = "
  Overview: This host is installed with OpenSSL and is prone to Denial Of
  Service Vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'kssl_keytab_is_available()' function in
  'ssl/kssl.c' which does not check a certain return value when Kerberos is
  enabled. This allows NULL pointer dereference and daemon crash via SSL
  cipher negotiation.

  Impact:
  Successful exploitation will let the attacker to cause denial of service
  conditions.

  Impact Level: Application

  Affected Software/OS:
  OpenSSL version prior to 0.9.8n on Windows.

  Fix: Upgrade to version 0.9.8n or later.
  For updates refer,http://www.slproweb.com/products/Win32OpenSSL.html

  References:
  http://seclists.org/oss-sec/2010/q1/175
  https://bugzilla.redhat.com/show_bug.cgi?id=569774
  https://bugzilla.redhat.com/show_bug.cgi?id=567711
  http://permalink.gmane.org/gmane.comp.security.oss.general/2636

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.2
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_openssl_detect_win.nasl");
  script_require_keys("OpenSSL/Win/Ver");
  exit(0);
}


include("version_func.inc");

opensslVer = get_kb_item("OpenSSL/Win/Ver");
if(isnull(opensslVer)){
  exit(0);
}

if(version_is_less(version:opensslVer, test_version:"0.9.8n")){
   security_warning(0);
}
