###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openssl_bnwexpand_mul_vuln_win.nasl 7599 2010-03-10 12:10:29Z mar $
#
# OpenSSL 'bn_wexpand()' Multiple Vulnerabilities (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800489);
  script_version("$Revision: 6941 $: 1.0");
  script_cve_id("CVE-2009-3245");
  script_name("OpenSSL 'bn_wexpand()' Multiple Vulnerabilities (Win)");
  desc = "
  Overview: This host is installed with OpenSSL and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to error in 'bn_wexpand()' function which does not
  check for a NULL return value when called in 'crypto/bn/bn_div.c',
  'crypto/bn/bn_gf2m.c', 'crypto/ec/ec2_smpl.c', and 'engines/e_ubsec.c'.

  Impact:
  Has unspecified impact and context-dependent attack vectors.

  Impact Level: Application

  Affected Software/OS:
  OpenSSL version prior to 0.9.8m on Windows.

  Fix: Upgrade to version 0.9.8m or later.
  For updates refer,http://www.slproweb.com/products/Win32OpenSSL.html

  References:
  http://secunia.com/advisories/38761
  http://marc.info/?l=openssl-cvs&m=126692159706582&w=2
  http://security-tracker.debian.org/tracker/CVE-2009-3245

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_openssl_detect_win.nasl");
  script_require_keys("OpenSSL/Win/Ver");
  exit(0);
}


include("version_func.inc");

opensslVer = get_kb_item("OpenSSL/Win/Ver");
if(!isnull(opensslVer))
{
  if(version_is_less(version:opensslVer, test_version:"0.9.8m")){
    security_hole(0);
  }
}
