###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opensc_detect.nasl 685 2009-03-10 20:06:59Z mar $
#
# OpenSC Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800369);
  script_version("$Revision: 1.0 $");
  script_name("OpenSC Version Detection");
  desc = "
  Overview: This script detects the version of OpenSC and sets the
  result in the KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of OpenSC");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

# Set KB for OpenSC
openscName = find_file(file_name:"opensc-config", file_path:"/",
                       useregex:TRUE, regexpar:"$", sock:sock);
if(openscName != NULL)
{
  foreach binName (openscName)
  {
    binName = chomp(binName);
    openscVer = get_bin_version(full_prog_name:binName, ver_pattern:"([0-9.]+)",
                                version_argv:"--version", sock:sock);
    if(openscVer[0] != NULL)
    {
      set_kb_item(name:"OpenSC/Ver", value:openscVer[0]);
      ssh_close_connection();
      exit(0);
    }
  }
}
ssh_close_connection();
