###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openpro_detect.nasl 4317 2009-09-03 13:58:24Z aug $
#
# OpenPro Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800928);
  script_version("Revision: 1.0 ");
  script_name("OpenPro Version Detection");
  desc = "
  Overview: This script detects the installed version of OpenPro and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the KB for the version of OpenPro");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

openPort = get_http_port(default:80);
if(!openPort){
  openPort = 80;
}
if(!get_port_state(openPort)){
  exit(0);
}

foreach dir (make_list("/", "/openpro", "/forum", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/login.php"), port:openPort);
  rcvRes = http_send_recv(port:openPort, data:sndReq);

  if("OpenPro" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    sndReq = http_get(item:string(dir, "/version"), port:openPort);
    rcvRes = http_send_recv(port:openPort, data:sndReq);

    if(rcvRes != NULL)
    {
      openproVer = eregmatch(pattern:"Content-Type:.*([0-9]\.[0-9]\.?[0-9]+)",
                             string:rcvRes);

      if(openproVer[1] != NULL)
      {
        set_kb_item(name:"www/" + openPort + "/OpenPro",
                    value:openproVer[1] + " under " + dir);
      }
    }
  }
}
