###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openoffice_senddoc_tmp_file_creation_vuln_lin.nasl 0438 2008-11-05 15:18:12Z nov $
#
# OpenOffice senddoc Insecure Temporary File Creation Vulnerability (Linux)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800129);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-4937");
  script_bugtraq_id(30925);
  script_name("OpenOffice senddoc Insecure Temporary File Creation Vulnerability (Linux)");
  desc = "

  Overview: The host has OpenOffice installed and is prone to Insecure
  Temporary File Creation Vulnerability.

  Vulnerability Insight:
  The flaw exists due to OpenOffice 'senddoc' which creates temporary files
  in an insecure manner, which allows users to overwrite files via a symlink
  attack on a /tmp/log.obr.##### temporary file.

  Impact: Successful exploitation allows attackers to delete or corrupt
  sensitive files, which may result in a denial of service condtion.

  Impact Level: Application

  Affected Software/OS:
  OpenOffice.org 2.4.1 on Linux.

  Fix: Upgrade OpenOffice to higher version.
  http://download.openoffice.org/index.html

  References:
  http://www.openwall.com/lists/oss-security/2008/10/30/2
  http://dev.gentoo.org/~rbu/security/debiantemp/openoffice.org-common

  CVSS Score:
    CVSS Base Score     : 7.6 (AV:N/AC:H/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Remote file access");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

filePath = find_file(file_name:"versionrc", sock:sock);
foreach path (filePath)
{
  path = chomp(path);
  if("openoffice" >!< path){
    continue;
  }

  openoffVer = get_bin_version(full_prog_name:"cat", version_argv:path,
                               ver_pattern:"[0-9]\.[0-9](\.[0-9])?");
  if(openoffVer != NULL)
  {
    if(openoffVer[0] == "2.4.1"){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
