###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openfire_mult_vuln.nasl 1003 2009-02-10 19:24:29Z feb $
#
# Ignite Realtime OpenFire Multiple Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800354);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0496", "CVE-2009-0497");
  script_bugtraq_id(32935, 32937, 32938, 32939, 32940, 32943, 32944, 32945);
  script_name("Ignite Realtime OpenFire Multiple Vulnerabilities");
  desc = "

  Overview: This host is running OpenFire and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  Application fails to sanitise the user inputs in,
  - log parameter to logviewer.jsp and log.jsp files,
  - search parameter to group-summary.jsp file,
  - username parameter to user-properties.jsp file,
  - logDir, maxTotalSize, maxFileSize, maxDays, and logTimeout parameters
    to audit-policy.jsp file,
  - propName parameter to server-properties.jsp file, and
  - roomconfig_roomname and roomconfig_roomdesc parameters to
    muc-room-edit-form.jsp file.

  Impact:
  Attacker may leverage this issue by executing arbitrary script code or
  injecting HTML or JavaScript code in the context of the affected system
  and can cause directory traversal or XSS attack.

  Impact Level: System

  Affected Software/OS:
  Ignite Realtime Openfire version prior to 3.6.3 on all platforms

  Fix: Upgrade to OpenFire version 3.6.3
  http://www.igniterealtime.org/downloads/index.jsp

  References:
  http://secunia.com/advisories/33452
  http://svn.igniterealtime.org/svn/repos/openfire/trunk/src/web/log.jsp
  http://www.securityfocus.com/archive/1/archive/1/499880/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 4.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of OpenFire");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_openfire_detect.nasl");
  script_require_ports("Services/www", 9090);
  exit(0);
}


include("version_func.inc");

firePort = get_kb_item("Services/www");
if(!firePort){
  exit(0);
}

fireVer = get_kb_item("www/" + firePort + "/Openfire");
if(fireVer != NULL)
{
  # Grep for Openfire version prior to 3.6.3
  if(version_is_less(version:fireVer, test_version:"3.6.3")){
    security_hole(firePort);
  }
}
