###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ntp_detect_lin.nasl 824 2009-01-13 13:00:34Z jan $
#
# NTP Version Detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800407);
  script_version("Revision: 1.0 ");
  script_name("NTP Version Detection (Linux)");
  desc = "
  Overview : The script detects the installed version of NTP and saves
  the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of NTP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("ntp_open.nasl");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

ntpVersion = get_kb_item("NTP/Linux/Ver");
if(!ntpVersion)
{
  sock = ssh_login_or_reuse_connection();
  if(!sock){
   exit(0);
  }

  binFiles = find_file(file_name:"ntpd",file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:sock);
  foreach binName (binFiles)
  {
    ntpVer = get_bin_version(full_prog_name:chomp(binName), sock:sock,
             version_argv:"--version",
             ver_pattern:"ntpd.* ([0-9]\.[0-9.]+)([a-z][0-9]+)?-?(RC[0-9])?");
    if(ntpVer[1] != NULL)
    {
      if(ntpVer[2] =~ "[a-z][0-9]+" && ntpVer[3] =~ "RC"){
        ntpVer = ntpVer[1] + "." + ntpVer[2] + "." + ntpVer[3];
       }
      else if(ntpVer[2] =~ "[a-z][0-9]+"){
        ntpVer = ntpVer[1] + "." + ntpVer[2];
       }
      else ntpVer = ntpVer[1];

      set_kb_item(name:"NTP/Linux/Ver", value:ntpVer);
      ssh_close_connection();
      exit(0);
    }
  }
  ssh_close_connection();
}
