###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_novell_groupwise_client_activex_bof_vuln.nasl 5622 2009-11-09 18:45:38Z nov $
#
# Novell Groupwise Client ActiveX Control Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800973);
  script_version("$ Revision: 1.0 $");
  script_cve_id("CVE-2009-3863");
  script_bugtraq_id(36398);
  script_name("Novell Groupwise Client ActiveX Control Buffer Overflow Vulnerability");
  desc = "
  Overview: This host is installed with Novell Groupwise Client ActiveX Control
  and is prone to Buffer Overflow vulnerability.

  Vulnerability Insight:
  A boundary error occurs in Novell Groupwise Client ActiveX control (gxmim1.dll)
  while handling overly long arguments passed to the 'SetFontFace()' method.

  Impact:
  Successful expoitation will allow remote attackers to execute arbitrary
  code on the affected system and may crash the client.

  Affected Software/OS:
  Novell GroupWise Client 7.0.3.1294 and prior on Windows.

  Fix:
  No solution or patch is available as on 09th November, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For further updates refer, http://www.novell.com/products/groupwise/

  Workaround:
  Set the Killbit for the vulnerable CLSID
  http://support.microsoft.com/kb/240797

  References:
  http://www.milw0rm.com/exploits/9683
  http://en.securitylab.ru/nvd/387373.php

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check the version of Novell Groupwise Client ActiveX control");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_novell_prdts_detect_win.nasl");
  script_require_keys("Novell/Groupwise/Client/Win/Ver");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

gcVer = get_kb_item("Novell/Groupwise/Client/Win/Ver");
if(gcVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:gcVer, test_version:"7.0.3.1294"))
{
  dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion"+
                                "\App Paths\GrpWise.exe", item:"Path");
  if(dllPath == NULL){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$", string:dllPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",  string:dllPath+
                                                          "\gxmim1.dll");
  dllVer = GetVer(share:share, file:file);

  # Check if gxmim1.dll version is 7.0.3.1294 or prior
  if(version_is_less_equal(version:dllVer, test_version:"7.0.3.1294"))
  {
    # Check if the Killbits are set
    if(is_killbit_set(clsid:"{9796BED2-C1CF-11D2-9384-0008C7396667}") == 0){
      security_warning(0);
    }
  }
}
