###############################################################################
# OpenVAS Vulnerability Test
# $Id:gb_nod32_email_message_dos.nasl 660 2008-12-12 18:30:29Z dec $
#
# NOD32 E-mail message Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800203);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5425");
  script_name("NOD32 Email Message Denial of Service Vulnerability");
  desc = "

  Overview: This host is installed with NOD32 Antivirus and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  This flaw is due to improper handling of multipart/mixed e-mail messages with
  many MIME parts and Email messages with many Content-type: message/rfc822
  headers.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application and can crash the application.

  Affected Software/OS:
  NOD32 AntiVirus version 2.70.0039.000 and prior.

  Fix:
  Upgrade to the latest version 3.x,
  http://www.eset.com/download

  References:
  http://www.packetstormsecurity.org/papers/general/mime-dos.txt

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of NOD32");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\ESET\ESET Security\CurrentVersion\Info")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
entries = registry_enum_keys(key:key);
foreach item (entries)
{
  node = registry_get_sz(key:key + item, item:"DisplayName");
  if("ESET NOD32 Antivirus" >< node)
  {
    nodeVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(nodeVer != NULL)
    {
      # Grep for version 2.70.0039.0000 or prior
      if(version_is_less_equal(version:nodeVer, test_version:"2.70.0039.0000")){
        security_warning(0);
      }
    }
    exit(0);
  }
}
