###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mysql_auth_bypass_vuln.nasl 5988 2009-12-03 25:29:17Z dec $
#
# MySQL Authenticated Access Restrictions Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801066);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-4030");
  script_name("MySQL Authenticated Access Restrictions Bypass Vulnerability");
  desc = "
  Overview: The host is running MySQL and is prone to Access restrictions Bypass
  Vulnerability

  Vulnerability Insight:
  The flaw is due to an error while calling CREATE TABLE on a MyISAM table with modified
  DATA DIRECTORY or INDEX DIRECTORY.

  Impact:
  Successful exploitation could allow users to bypass intended access restrictions
  by calling CREATE TABLE with DATA DIRECTORY or INDEX DIRECTORY argument referring
  to a subdirectory.

  Impact Level: Application

  Affected Software/OS:
  MySQL 5.1.x before 5.1.41 on all running platform.

  Fix: Upgrade to MySQL version 5.1.41
  For Updates Refer, http://dev.mysql.com/downloads

  References:
  http://bugs.mysql.com/bug.php?id=32167
  http://dev.mysql.com/doc/refman/5.1/en/news-5-1-41.html

  CVSS Score:
    CVSS Base Score      : 4.4 (AV:L/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of MySQL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("mysql_version.nasl");
  script_require_ports("Services/mysql", 3306);
  exit(0);
}


include("misc_func.inc");
include("version_func.inc");

sqlPort = get_kb_item("Services/mysql");
if(!sqlPort){
  sqlPort = 3306;
}

if(!get_port_state(sqlPort)){
  exit(0);
}

mysqlVer = get_mysql_version(port:sqlPort);
if(!isnull(mysqlVer))
{
  mysqlVer = eregmatch(pattern:"([0-9.a-z]+)", string:mysqlVer);
  if(!isnull(mysqlVer[1]))
  {
    if(version_in_range(version:mysqlVer[1], test_version:"5.1",test_version2:"5.1.40")){
      security_warning(sqlPort);
    }
  }
}

