###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_win_live_messenger_detect.nasl 814 2009-01-06 12:01:29Z jan $
#
# Microsoft Windows Live Messenger Client Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# Update to detect the Messenger Plus! Live
#  - By Sharath S <sharaths@secpod.com> on 2009-07-31
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800331);
  script_version("$Revision: 1.1 $");
  script_name("Microsoft Windows Live Messenger Client Version Detection");
  desc = "
  Overview: This script detects the version of Microsoft Windows Live Messenger
  Client on remote host and sets the KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Windows Live Messenger");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\Windows Live\Messenger")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  # Windows Live Messenger
  if("Windows Live Messenger" >< registry_get_sz(key:key + item,
                                                 item:"DisplayName"))
  {
    livemgrVer = registry_get_sz(key:key + item, item:"DisplayVersion");

    # Set KB for Windows Live Messenger
    if(!isnull(livemgrVer)){
      set_kb_item(name:"MS/LiveMessenger/Ver", value:livemgrVer);
    }
  }

  # Messenger Plus! 
  if("Messenger Plus!" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    msgPlusVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    plusPath = registry_get_sz(key:key + item, item:"UninstallString");
    plusPath = eregmatch(pattern:'"(.*)"', string:plusPath);

    if(isnull(msgPlusVer))
    {
      share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:plusPath[1]);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:plusPath[1]);

      if("Uninstall.exe" >< file)
      {
        file -= "Uninstall.exe" + "MPTools.exe";
        msgPlusVer = GetVer(file:file, share:share);
      }
      else if("MsgPlus.exe" >< file)
        msgPlusVer = GetVer(file:file, share:share);
    }

    # Set KB for Version and Path of Messenger Plus!
    if(!isnull(msgPlusVer))
    {
      set_kb_item(name:"MS/MessengerPlus/Ver", value:msgPlusVer);
      set_kb_item(name:"MS/MessengerPlus/Path", value:plusPath[1]);
    }
  }
}
