###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_kernel_prv_esc_vuln.nasl 6919 2010-01-21 12:40:05Z jan $
#
# Microsoft Windows #GP Trap Handler Privilege Escalation Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800442);
  script_version("$Revision: 6743 $: 1.0");
  script_cve_id("CVE-2010-0232");
  script_name("Microsoft Windows GP Trap Handler Privilege Escalation Vulnerability");
  desc = "
  Overview:
  The host is installed with Microsoft Windows operating system and is prone to
  Privilege Escalation Vulnerability.

  Vulnerability Insight:
  This issue is caused due to the kernel not properly handling certain
  exceptions when setting up a VDM (Virtual DOS Machine) context, which
  allows users to gain kernel privileges by setting up a crafted 'DM_TIB'
  in their 'TEB' and reach the 'Ki386BiosCallReturnAddress()' function via
  the '#GP trap handler (nt!KiTrap0D)'.

  Impact:
  Successful exploitation will allow remote attackers to bypass certain security
  restrictions or can gain escalated privileges via specially crafted attack.

  Impact Level: System.

  Affected Software/OS:
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2000 Service Pack 4 and prior.
  Microsoft Windows Server 2003 Service Pack 2 and prior.

  Fix: No solution or patch is available as on 21st January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/technet/security/advisory/979682.mspx

  Workaround:
  Apply workaround as in the advisory.
  http://www.microsoft.com/technet/security/advisory/979682.mspx

  References:
  http://isc.sans.org/diary.html?storyid=8050
  http://www.vupen.com/english/advisories/2010/0179
  http://www.microsoft.com/technet/security/advisory/979682.mspx
  http://foro.elhacker.net/bugs_y_exploits/0day_m_iquestcve20100232-t281831.0.html

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 8.0
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Microsoft Windows");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# Checking For the workaround
dkey ="SOFTWARE\Policies\Microsoft\Windows\AppCompat";
if(registry_key_exists(key:dkey))
{

  dValue = registry_get_dword(key:dkey, item:"VDMDisallowed");
  if(dValue != "1")
  {
    security_hole(0);
    exit(0);
  }
}
else
{
 security_hole(0);
}
