###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_xml_doc_dos_vuln_aug09.nasl 3820 2009-08-07 18:15:24Z aug $
#
# Microsoft Internet Explorer XML Document DoS Vulnerability - Aug09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800863);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2668");
  script_name("Microsoft Internet Explorer XML Document DoS Vulnerability - Aug09");
  desc = "

  Overview: This host has Internet Explorer installed and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  The flaw exists via an XML document composed of a long series of start-tags
  with no corresponding end-tags and it leads to CPU consumption.

  Impact:
  Successful exploitation could allow remote attackers to cause Denial of
  Service in the context of an affected application.

  Impact Level: Application

  Affected Software/OS:
  Internet Explorer version 6.x to 6.0.2900.2180 and 7.x to 7.0.6000.16473

  Fix: No solution or patch is available as on 07th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/products/default.aspx

  References:
  http://websecurity.com.ua/3216/
  http://archives.neohapsis.com/archives/bugtraq/2009-07/0193.html

  CVSS Score:
    CVSS Base Score      : 7.8 (AV:N/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score  : 6.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/EXE/Ver");
  exit(0);
}


include("version_func.inc");

# Get for Internet Explorer Version
ieVer = get_kb_item("MS/IE/EXE/Ver");

if(!isnull(ieVer))
{
  # Check for IE version 6.0 <= 6.0.2900.2180 or 7.0 <= 7.0.6000.16473
  if(version_in_range(version:ieVer, test_version:"6.0",
                                    test_version2:"6.0.2900.2180")||
     version_in_range(version:ieVer, test_version:"7.0",
                                    test_version2:"7.0.6000.16473")){
    security_hole(0);
  }
}
