###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_findtext_dos_vuln_aug09.nasl 3792 2009-08-06 10:19:24Z aug $
#
# Microsoft Internet Explorer 'findText()' Unicode Parsing DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800861);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2655");
  script_bugtraq_id(35799);
  script_name("Microsoft Internet Explorer 'findText()' Unicode Parsing DoS Vulnerability");
  desc = "

  Overview: This host has Internet Explorer installed and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in mshtml.dll file and it can causes while
  calling the JavaScript findText method with a crafted Unicode string in the
  first argument, and only one additional argument, as demonstrated by a second
  argument of -1.

  Impact:
  Successful exploitation could allow remote attackers to cause the application
  to crash.

  Impact Level: Application

  Affected Software/OS:
  Microsoft, Internet Explorer version 7.x/8.x

  Fix: No solution or patch is available as on 05th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/products/default.aspx

  References:
  http://www.milw0rm.com/exploits/9253

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

# Check for XP SP3
SP = get_kb_item("SMB/WinXP/ServicePack");
if("Service Pack 3" >< SP)
{
  # Get for Internet Explorer Version
  ieVer = get_kb_item("MS/IE/Version");
  # Check for IE 7/8
  if(ieVer =~ "^[7|8]\..*")
  {
    dllPath = registry_get_sz(item:"Install Path",
                              key:"SOFTWARE\Microsoft\COM3\Setup");
    dllPath += "\mshtml.dll";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

    # Get for mshtml.dll Version
    mshtmlVer = GetVer(file:file, share:share);
    if(isnull(mshtmlVer))
      exit(0);

    # Check for DLL version 7.0 <= 7.0.6000.16890 or 8.0 <= 8.0.6001.18812
    if(version_in_range(version:mshtmlVer, test_version:"7.0",
                                          test_version2:"7.0.6000.16890")||
       version_in_range(version:mshtmlVer, test_version:"8.0",
                                          test_version2:"8.0.6001.18812")){
      security_warning(0);
    }
  }
}
