###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_moziloCMS_mult_xss_vuln.nasl 6078 2009-12-07 15:11:27Z dec $
#
# moziloCMS Multiple Cross Site Scripting Vulnerabilities
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801076);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-4209");
  script_bugtraq_id(35212);
  script_name("moziloCMS Multiple Cross Site Scripting Vulnerabilities");
  desc = "
  Overview: The host is running moziloCMS and is prone to Multiple Cross Site
  Scripting Vulnerabilities

  Vulnerability Insight:
  The flaws are due to an error in 'admin/index.php'. The input values are not
  properly verified before being used via 'cat' and file parameters in an
  'editsite' action.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary HTML
  and script code in a user's browser session in the context of an affected
  site.

  Impact Level: Application.

  Affected Software/OS:
  moziloCMS version 1.11.1 and prior on all running platform.

  Fix:
  No solution or patch is available as on 07th December, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://cms.mozilo.de/index.php?cat=10_moziloCMS&page=50_Download

  References:
  http://en.securitylab.ru/nvd/388498.php
  http://downloads.securityfocus.com/vulnerabilities/exploits/35212.txt

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 6.7
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of moziloCMS ");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_dependencies("mozilloCMS_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

mzVer = get_http_port(default:80);
if(!mzVer){
  exit(0);
}

mzVer = get_kb_item("www/" + mzVer + "/moziloCMS");
if(!mzVer){
  exit(0);
}

mzVer = eregmatch(pattern:"^(.+) under (/.*)$", string:mzVer);
if(mzVer[1] != NULL)
{
  if(version_is_less_equal(version:mzVer[1], test_version:"1.11.1")){
    security_hole(mzVer);
  }
}

