###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_moinmoin_wiki_cfg_pkg_unspecified_vuln.nasl 7492 2010-03-05 17:24:29Z mar $
#
# MoinMoin Wiki 'cfg' Package Configuration Unspecified Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800174);
  script_version("$Revision: 6915 $: 1.0");
  script_cve_id("CVE-2010-0717");
  script_name("MoinMoin Wiki 'cfg' Package Configuration Unspecified Vulnerability");
  desc = "
  Overview: This host is running MoinMoin Wiki and is prone to unspecified
  vulnerabilities.

  Vulnerability Insight:
  The flaw is due to default configuration of 'cfg' package which does not
  prevent unsafe package actions causing unspecified impact.

  Impact:
  Impack is currently unknown.

  Impact Level: Application

  Affected Software/OS:
  MoinMoin Wiki version before 1.8.7 on all platforms.

  Fix: Upgrade to MoinMoin Wiki 1.8.7 or later
  For updates refer, http://moinmo.in/MoinMoinDownload

  References:
  http://moinmo.in/MoinMoinRelease1.8
  http://www.openwall.com/lists/oss-security/2010/02/15/2
  http://moinmo.in/SecurityFixes/AdvisoryForDistributors

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of MoinMoin Wiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_moinmoin_wiki_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

## Get the port where MoinMoin Wiki application is running
moinWikiPort = get_http_port(default:80);
if(!moinWikiPort){
  exit(0);
}

## Get MoinMoin Wiki Version from KB
moinWikiVer = get_kb_item("www/" + moinWikiPort + "/moinmoinWiki");
moinWikiVer = eregmatch(pattern:"^(.+) under (/.*)$", string:moinWikiVer);

if(moinWikiVer[1] != NULL)
{
  ## Check for version before 1.8.7
  if(version_is_less(version:moinWikiVer[1], test_version:"1.8.7")){
    security_hole(moinWikiPort);
  }
}
