###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_modesecurity_remote_dos_vuln.nasl 2650 2009-06-08 14:15:29Z jun $
#
# ModSecurity Multiple Remote Denial of Service Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800626);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1902", "CVE-2009-1903");
  script_bugtraq_id(34096);
  script_name("ModSecurity Multiple Remote Denial of Service Vulnerabilities");
  desc = "

  Overview: This host is running ModSecurity and is prone to Denial of Service
  Vulnerabilities.

  Vulnerability Insight:
  The multiple flaws are due to,
  - An error in the PDF XSS protection implementation which can be exploited
    to cause a crash via a specially crafted HTTP request.
  - NULL pointer dereference error when parsing multipart requests can be
    exploited to cause a crash via multipart content with a missing part header
    name.

  Impact:
  Successful exploitation could allow remote attackers to cause denial of
  service.

  Affected Software/OS:
  ModSecurity version prior to 2.5.9 on Linux.

  Fix:
  Upgrade to version 2.5.9 or later.
  http://www.modsecurity.org/download/

  References:
  http://secunia.com/advisories/34256
  http://www.milw0rm.com/exploits/8241
  http://www.vupen.com/english/advisories/2009/0703

  CVSS Score:
    CVSS Base Score      : 7.8 (AV:N/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score  : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of ModSecurity");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web Servers");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

grep = find_bin(prog_name:"grep", sock:sock);
grep = chomp(grep[0]);

garg[0] = "-o";
garg[1] = "-m1";
garg[2] = "-a";
garg[3] = string("ModSecurity v[0-9]\\+.[0-9]\\+.[0-9]\\+");

modName = find_file(file_name:"mod_security2.so", file_path:"/",
                    useregex:TRUE, regexpar:"$", sock:sock);

foreach binaryName (modName)
{
  binaryName = chomp(binaryName);
  if(islocalhost())
  {
    garg[4] = binaryName;
    arg = garg;
  }
  else
  {
    arg = garg[0] + " " + garg[1] + " " + garg[2] + " " + raw_string(0x22) +
          garg[3] + raw_string(0x22) + " " + binaryName;
  }

  modsecVer = get_bin_version(full_prog_name:grep, version_argv:arg,
                              ver_pattern:"[0-9]+.[0-9]+.[0-9]+", sock:sock);
  if(modsecVer[0] != NULL)
  {
    if(version_is_less(version:modsecVer[0], test_version:"2.5.9")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
