###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for urpmi MDVA-2010:098 (urpmi)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830944);
  script_version("$Revision: 6957 $: 1.0");
  script_xref(name: "MDVA", value: "2010:098");
  script_name("Mandriva Update for urpmi MDVA-2010:098 (urpmi)");
  desc = "

  Vulnerability Insight:

  Fix packages signature management when a package is in 2
  sub-repositories same version but different signature. This problem
  occured when local media were used.

  Affected Software/OS:
  urpmi on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64,
  Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-03/msg00020.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of urpmi");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"gurpmi", rpm:"gurpmi~6.14.16~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi", rpm:"urpmi~6.14.16~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-ldap", rpm:"urpmi-ldap~6.14.16~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ka-run", rpm:"urpmi-parallel-ka-run~6.14.16~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ssh", rpm:"urpmi-parallel-ssh~6.14.16~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-recover", rpm:"urpmi-recover~6.14.16~1.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"gurpmi", rpm:"gurpmi~6.14.16~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi", rpm:"urpmi~6.14.16~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-ldap", rpm:"urpmi-ldap~6.14.16~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ka-run", rpm:"urpmi-parallel-ka-run~6.14.16~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ssh", rpm:"urpmi-parallel-ssh~6.14.16~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-recover", rpm:"urpmi-recover~6.14.16~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}