###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for nufw MDVA-2010:094 (nufw)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830923);
  script_version("$Revision: 6957 $: 1.0");
  script_xref(name: "MDVA", value: "2010:094");
  script_name("Mandriva Update for nufw MDVA-2010:094 (nufw)");
  desc = "

  Vulnerability Insight:

  This update provides the latest version of nufw software suite,
  with many bugfixes and usage improvements.

  Affected Software/OS:
  nufw on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-03/msg00012.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nufw");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"libnuclient1", rpm:"libnuclient1~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnufw-devel", rpm:"libnufw-devel~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nuface", rpm:"nuface~2.0.16~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw", rpm:"nufw~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth", rpm:"nufw-nuauth~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-auth-ldap", rpm:"nufw-nuauth-auth-ldap~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-auth-mysql", rpm:"nufw-nuauth-auth-mysql~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-log-mysql", rpm:"nufw-nuauth-log-mysql~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-log-pgsql", rpm:"nufw-nuauth-log-pgsql~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-log-prelude", rpm:"nufw-nuauth-log-prelude~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nutcpc", rpm:"nufw-nutcpc~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-utils", rpm:"nufw-utils~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nulog", rpm:"nulog~2.1.5~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pam_nufw", rpm:"pam_nufw~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-nufw", rpm:"python-nufw~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw", rpm:"nufw~2.4.0~0.1mdvmes2009.0", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nuclient1", rpm:"lib64nuclient1~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nufw-devel", rpm:"lib64nufw-devel~2.4.0~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}