###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for firefox MDVA-2010:016 (firefox)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830794);
  script_version("$Revision: 6414 $: 1.0");
  script_xref(name: "MDVA", value: "2010:016");
  script_name("Mandriva Update for firefox MDVA-2010:016 (firefox)");
  desc = "

  Vulnerability Insight:

  It was dicovered that the kde4ff theme for firefox 3.5
  (firefox-theme-kde4ff) did not work, to address this problem the
  kfirefox theme (firefox-theme-kfirefox) is provided as a drop in
  replacement.
  
  It was discovered that the beagle extension for firefox
  (firefox-ext-beagle) had the wrong release number which prevented it
  from being upgraded.
  
  This advisory addresses these problems.

  Affected Software/OS:
  firefox on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00024.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"beagle", rpm:"beagle~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"beagle-crawl-system", rpm:"beagle-crawl-system~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"beagle-doc", rpm:"beagle-doc~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"beagle-evolution", rpm:"beagle-evolution~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"beagle-gui", rpm:"beagle-gui~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"beagle-gui-qt", rpm:"beagle-gui-qt~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"beagle-libs", rpm:"beagle-libs~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox-ext-beagle", rpm:"firefox-ext-beagle~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox-theme-kfirefox", rpm:"firefox-theme-kfirefox~0.16~7.3mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-thunderbird-beagle", rpm:"mozilla-thunderbird-beagle~0.3.9~20.5mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}