###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdepim4 MDVA-2010:013 (kdepim4)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830778);
  script_version("$Revision: 6414 $: 1.0");
  script_xref(name: "MDVA", value: "2010:013");
  script_name("Mandriva Update for kdepim4 MDVA-2010:013 (kdepim4)");
  desc = "

  Vulnerability Insight:

  In mandriva 2010.0, there was a layout pb in the Kontact Planner
  plugin.
  
  In Korganizer, in the TODO Mode, the first line of text wasn't viewable
  in non rich text mode.
  
  This update fixes these issues.

  Affected Software/OS:
  kdepim4 on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00016.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdepim4");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"akregator", rpm:"akregator~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kaddressbook", rpm:"kaddressbook~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kalarm", rpm:"kalarm~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim4", rpm:"kdepim4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim4-core", rpm:"kdepim4-core~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim4-devel", rpm:"kdepim4-devel~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim4-kresources", rpm:"kdepim4-kresources~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim4-wizards", rpm:"kdepim4-wizards~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kjots", rpm:"kjots~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kleopatra", rpm:"kleopatra~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kmail", rpm:"kmail~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kmailcvt", rpm:"kmailcvt~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"knode", rpm:"knode~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"knotes", rpm:"knotes~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kontact", rpm:"kontact~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"korganizer", rpm:"korganizer~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kpilot", rpm:"kpilot~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ksendemail", rpm:"ksendemail~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ktimetracker", rpm:"ktimetracker~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libakregatorinterfaces4", rpm:"libakregatorinterfaces4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libakregatorprivate4", rpm:"libakregatorprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgwsoap4", rpm:"libgwsoap4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkabc_groupdav4", rpm:"libkabc_groupdav4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkabc_groupwise4", rpm:"libkabc_groupwise4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkabckolab4", rpm:"libkabckolab4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkabcommon4", rpm:"libkabcommon4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkabcscalix4", rpm:"libkabcscalix4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkabc_slox4", rpm:"libkabc_slox4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkabc_xmlrpc4", rpm:"libkabc_xmlrpc4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkabinterfaces4", rpm:"libkabinterfaces4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkaddressbookprivate4", rpm:"libkaddressbookprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkalarm_resources4", rpm:"libkalarm_resources4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkcal_groupdav4", rpm:"libkcal_groupdav4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkcal_groupwise4", rpm:"libkcal_groupwise4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkcalkolab4", rpm:"libkcalkolab4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkcal_resourceblog4", rpm:"libkcal_resourceblog4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkcal_resourceremote4", rpm:"libkcal_resourceremote4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkcalscalix4", rpm:"libkcalscalix4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkcal_slox4", rpm:"libkcal_slox4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkcal_xmlrpc4", rpm:"libkcal_xmlrpc4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim4", rpm:"libkdepim4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkgroupwarebase4", rpm:"libkgroupwarebase4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkgroupwaredav4", rpm:"libkgroupwaredav4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkleo4", rpm:"libkleo4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkleopatraclientcore4", rpm:"libkleopatraclientcore4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkleopatraclientgui4", rpm:"libkleopatraclientgui4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkmailprivate4", rpm:"libkmailprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libknodecommon4", rpm:"libknodecommon4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libknoteskolab4", rpm:"libknoteskolab4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libknotesscalix4", rpm:"libknotesscalix4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libknotes_xmlrpc4", rpm:"libknotes_xmlrpc4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkontactinterfaces4", rpm:"libkontactinterfaces4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkontactprivate4", rpm:"libkontactprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkorganizer_calendar4", rpm:"libkorganizer_calendar4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkorganizer_core4", rpm:"libkorganizer_core4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkorganizer_eventviewer4", rpm:"libkorganizer_eventviewer4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkorganizer_interfaces4", rpm:"libkorganizer_interfaces4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkorganizerprivate4", rpm:"libkorganizerprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkorg_stdprinting4", rpm:"libkorg_stdprinting4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkpgp4", rpm:"libkpgp4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkpilot5", rpm:"libkpilot5~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libksieve4", rpm:"libksieve4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkslox4", rpm:"libkslox4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmimelib4", rpm:"libmimelib4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64akregatorinterfaces4", rpm:"lib64akregatorinterfaces4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64akregatorprivate4", rpm:"lib64akregatorprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gwsoap4", rpm:"lib64gwsoap4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kabc_groupdav4", rpm:"lib64kabc_groupdav4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kabc_groupwise4", rpm:"lib64kabc_groupwise4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kabckolab4", rpm:"lib64kabckolab4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kabcommon4", rpm:"lib64kabcommon4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kabcscalix4", rpm:"lib64kabcscalix4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kabc_slox4", rpm:"lib64kabc_slox4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kabc_xmlrpc4", rpm:"lib64kabc_xmlrpc4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kabinterfaces4", rpm:"lib64kabinterfaces4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kaddressbookprivate4", rpm:"lib64kaddressbookprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kalarm_resources4", rpm:"lib64kalarm_resources4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kcal_groupdav4", rpm:"lib64kcal_groupdav4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kcal_groupwise4", rpm:"lib64kcal_groupwise4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kcalkolab4", rpm:"lib64kcalkolab4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kcal_resourceblog4", rpm:"lib64kcal_resourceblog4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kcal_resourceremote4", rpm:"lib64kcal_resourceremote4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kcalscalix4", rpm:"lib64kcalscalix4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kcal_slox4", rpm:"lib64kcal_slox4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kcal_xmlrpc4", rpm:"lib64kcal_xmlrpc4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim4", rpm:"lib64kdepim4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kgroupwarebase4", rpm:"lib64kgroupwarebase4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kgroupwaredav4", rpm:"lib64kgroupwaredav4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kleo4", rpm:"lib64kleo4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kleopatraclientcore4", rpm:"lib64kleopatraclientcore4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kleopatraclientgui4", rpm:"lib64kleopatraclientgui4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kmailprivate4", rpm:"lib64kmailprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64knodecommon4", rpm:"lib64knodecommon4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64knoteskolab4", rpm:"lib64knoteskolab4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64knotesscalix4", rpm:"lib64knotesscalix4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64knotes_xmlrpc4", rpm:"lib64knotes_xmlrpc4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kontactinterfaces4", rpm:"lib64kontactinterfaces4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kontactprivate4", rpm:"lib64kontactprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64korganizer_calendar4", rpm:"lib64korganizer_calendar4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64korganizer_core4", rpm:"lib64korganizer_core4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64korganizer_eventviewer4", rpm:"lib64korganizer_eventviewer4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64korganizer_interfaces4", rpm:"lib64korganizer_interfaces4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64korganizerprivate4", rpm:"lib64korganizerprivate4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64korg_stdprinting4", rpm:"lib64korg_stdprinting4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kpgp4", rpm:"lib64kpgp4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kpilot5", rpm:"lib64kpilot5~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ksieve4", rpm:"lib64ksieve4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kslox4", rpm:"lib64kslox4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mimelib4", rpm:"lib64mimelib4~4.3.2~2.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}