###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for lirc MDVA-2008:139 (lirc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830477);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:139");
  script_cve_id("");
  script_name( "Mandriva Update for lirc MDVA-2008:139 (lirc)");
  desc = "

  Vulnerability Insight:

  The lirc_dev module contained in the dkms-lirc package shipped with
  Mandriva Linux 2009 contains a bug which would cause it to crash (oops)
  immediately on load. The result of this is that lirc is unusable,
  and if you have dkms-lirc installed and the 'lircd' service enabled,
  the system may fail to boot correctly. The updated package fixes this
  bug and provides a set of lirc modules that load and work correctly.
  
  Please note that this issue only affects systems with the actual IR
  hardware that lirc works with.

  Affected Software/OS:
  lirc on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00013.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of lirc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"dkms-lirc", rpm:"dkms-lirc~0.8.3~4.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dkms-lirc-gpio", rpm:"dkms-lirc-gpio~0.8.3~4.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dkms-lirc-parallel", rpm:"dkms-lirc-parallel~0.8.3~4.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"liblirc0", rpm:"liblirc0~0.8.3~4.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"liblirc-devel", rpm:"liblirc-devel~0.8.3~4.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lirc", rpm:"lirc~0.8.3~4.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64lirc0", rpm:"lib64lirc0~0.8.3~4.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64lirc-devel", rpm:"lib64lirc-devel~0.8.3~4.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}