###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for dkms MDVA-2008:070 (dkms)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830689);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:070");
  script_cve_id("");
  script_name( "Mandriva Update for dkms MDVA-2008:070 (dkms)");
  desc = "

  Vulnerability Insight:

  The dkms-minimal package in Mandriva Linux 2008 Spring did not require
  lsb-release. If lsb-release was not installed, the dkms modules were
  installed in the standard location, instead of the intended /dkms or
  /dkms-binary. This update fixes that issue.
  
  Due to another bug, dkms would consider older installed binary dkms
  modules as original modules when installing a newer version of the
  module as a source dkms package, thus wrongly moving the binary
  modules around. This update disables original_module handling, not
  needed anymore since the rework of dkms system in 2008 Spring.
  
  Dkms would also print an error message during an upgrade of binary
  module packages, and under certain conditions an additional warning
  message regarding multiple modules being found. This update removes
  those harmless messages when they are not appropriate.

  Affected Software/OS:
  dkms on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00029.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of dkms");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"dkms", rpm:"dkms~2.0.19~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dkms-minimal", rpm:"dkms-minimal~2.0.19~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}