###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for rpmdrake MDVA-2008:033 (rpmdrake)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830764);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:033");
  script_cve_id("");
  script_name( "Mandriva Update for rpmdrake MDVA-2008:033 (rpmdrake)");
  desc = "

  Vulnerability Insight:

  rpmdrake in Mandriva Linux 2007.1 cannot install packages that
  are excluded by /etc/urpmi/skip.list.  This is not how the
  system is intended to work (these packages should be left out of
  automatic updates, but should be installable manually if the user
  wishes).  This bug made it difficult to install, for instance, the
  kernel-source-stripped-latest package, as it is listed in skip.list
  by default.
  
  This update fixes the problem and allows the user manually to install
  packages listed in skip.list if they so choose.

  Affected Software/OS:
  rpmdrake on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-03/msg00000.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of rpmdrake");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"park-rpmdrake", rpm:"park-rpmdrake~3.69.3~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rpmdrake", rpm:"rpmdrake~3.69.3~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}