###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for skencil MDVA-2008:013 (skencil)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830741);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:013");
  script_cve_id("");
  script_name( "Mandriva Update for skencil MDVA-2008:013 (skencil)");
  desc = "

  Vulnerability Insight:

  The package for the drawing application Skencil contained a bug
  which causes it not to be able to access the system fonts correctly.
  Consequently, it was impossible to enter text properly in Skencil,
  and Skencil would consume a high level of system resources if
  you attempt to use the text tools.  Also, Skencil would not run on
  x86-64 installations of Mandriva Linux 2007 Spring, crashing with an
  'undefined symbol: Py_InitModule4' error.
  
  The updated packages fix both issues, and also add Skencil to the
  system menus.

  Affected Software/OS:
  skencil on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00032.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of skencil");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"skencil", rpm:"skencil~0.6.18~0.695.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"skencil", rpm:"skencil~0.6.18~0.695.4.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}