###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for nss_ldap MDKA-2007:137 (nss_ldap)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830309);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:137");
  script_cve_id("");
  script_name( "Mandriva Update for nss_ldap MDKA-2007:137 (nss_ldap)");
  desc = "

  Vulnerability Insight:

  This update corrects an issue in nss_ldap when handling SIGPIPE,
  which could manifest itself in many different ways in systems running
  with nss_ldap installed and configured, such as a simple application
  silent error to a complete abort.

  Affected Software/OS:
  nss_ldap on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-12/msg00025.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nss_ldap");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"nss_ldap-257", rpm:"nss_ldap-257~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}