###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for urpmi MDKA-2007:123 (urpmi)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830264);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:123");
  script_cve_id("");
  script_name( "Mandriva Update for urpmi MDKA-2007:123 (urpmi)");
  desc = "

  Vulnerability Insight:

  The package included with Mandriva Linux 2008 for urpmi, the Mandriva
  package management tool, has regressions in the behaviour of the --src
  and --install-src parameters. The --install-src parameter fails to
  work at all. The --src parameter does not download and install the
  actual .src.rpm as it did in previous releases, it only installs the
  necessary build dependencies.
  
  This update fixes these issues.

  Affected Software/OS:
  urpmi on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00056.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of urpmi");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"gurpmi", rpm:"gurpmi~4.10.14.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi", rpm:"urpmi~4.10.14.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-ldap", rpm:"urpmi-ldap~4.10.14.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ka-run", rpm:"urpmi-parallel-ka-run~4.10.14.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ssh", rpm:"urpmi-parallel-ssh~4.10.14.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-recover", rpm:"urpmi-recover~4.10.14.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}