###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for printerdrake MDKA-2007:122 (printerdrake)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830328);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:122");
  script_cve_id("");
  script_name( "Mandriva Update for printerdrake MDKA-2007:122 (printerdrake)");
  desc = "

  Vulnerability Insight:

  In Mandriva Linux 2007 Spring, printerdrake would not detect many
  network printers, due to defaulting to using a less comprehensive
  printer scan method than previous releases did. (bug 30090)
  
  When changing the protocol for a configured network printer,
  printerdrake released with Mandriva Linux 2007 Spring would not update
  the associated protocol port number, leaving it in a non-working
  state. Also, general reconfiguration of network printers would fail,
  due to the use of an incorrect command. (bug 29524)
  
  This update fixes these issues.

  Affected Software/OS:
  printerdrake on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00053.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of printerdrake");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"printerdrake", rpm:"printerdrake~1.5.7.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"printerdrake-common", rpm:"printerdrake-common~1.5.7.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}