###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mandriva-doc MDKA-2007:104 (mandriva-doc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830195);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:104");
  script_cve_id("");
  script_name( "Mandriva Update for mandriva-doc MDKA-2007:104 (mandriva-doc)");
  desc = "

  Vulnerability Insight:

  The Mandriva documentation as shipped in Mandriva Linux 2008.0 did
  not contain the full pt_BR translation.  This update provides it and
  some other minor documentation fixes.

  Affected Software/OS:
  mandriva-doc on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00006.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mandriva-doc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"mandriva-doc-DVD-Booklet-en", rpm:"mandriva-doc-DVD-Booklet-en~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-DVD-Booklet-fr", rpm:"mandriva-doc-DVD-Booklet-fr~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-DVD-Booklet-pt_br", rpm:"mandriva-doc-DVD-Booklet-pt_br~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Drakxtools-Guide-de", rpm:"mandriva-doc-Drakxtools-Guide-de~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Drakxtools-Guide-en", rpm:"mandriva-doc-Drakxtools-Guide-en~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Drakxtools-Guide-es", rpm:"mandriva-doc-Drakxtools-Guide-es~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Drakxtools-Guide-fr", rpm:"mandriva-doc-Drakxtools-Guide-fr~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Drakxtools-Guide-it", rpm:"mandriva-doc-Drakxtools-Guide-it~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Drakxtools-Guide-pt_br", rpm:"mandriva-doc-Drakxtools-Guide-pt_br~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Starter-de", rpm:"mandriva-doc-Starter-de~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Starter-en", rpm:"mandriva-doc-Starter-en~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Starter-es", rpm:"mandriva-doc-Starter-es~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Starter-fr", rpm:"mandriva-doc-Starter-fr~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-Starter-it", rpm:"mandriva-doc-Starter-it~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-common", rpm:"mandriva-doc-common~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-installer-help", rpm:"mandriva-doc-installer-help~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc", rpm:"mandriva-doc~2008.0~0.20mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}