###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libusb MDKA-2007:071 (libusb)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830053);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:071");
  script_cve_id("");
  script_name( "Mandriva Update for libusb MDKA-2007:071 (libusb)");
  desc = "

  Vulnerability Insight:

  The libusb0.1_4-devel package was built with incorrect Provides,
  which prevented several other packages, such as libmtp5-devel from
  installing  due to packaging errors. The updated package fixes this
  problem and includes the necessary Provides to ensure that these
  packages can be installed without problems.

  Affected Software/OS:
  libusb on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00048.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libusb");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libusb0.1_4", rpm:"libusb0.1_4~0.1.12~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libusb0.1_4-devel", rpm:"libusb0.1_4-devel~0.1.12~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libusb0.1_4-static-devel", rpm:"libusb0.1_4-static-devel~0.1.12~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libusb", rpm:"libusb~0.1.12~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64usb0.1_4", rpm:"lib64usb0.1_4~0.1.12~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64usb0.1_4-devel", rpm:"lib64usb0.1_4-devel~0.1.12~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64usb0.1_4-static-devel", rpm:"lib64usb0.1_4-static-devel~0.1.12~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}