###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gnome-media MDKA-2007:051 (gnome-media)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830016);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:051");
  script_cve_id("");
  script_name( "Mandriva Update for gnome-media MDKA-2007:051 (gnome-media)");
  desc = "

  Vulnerability Insight:

  A window modality bug was preventing audio profile editing from
  Sound-juicer or Rhythmbox applications.  This bug is fixed with the
  updated gnome-media package.

  Affected Software/OS:
  gnome-media on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-05/msg00035.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gnome-media");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"gnome-media", rpm:"gnome-media~2.18.0~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcddb-slave2_0", rpm:"libcddb-slave2_0~2.18.0~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcddb-slave2_0-devel", rpm:"libcddb-slave2_0-devel~2.18.0~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cddb-slave2_0", rpm:"lib64cddb-slave2_0~2.18.0~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cddb-slave2_0-devel", rpm:"lib64cddb-slave2_0-devel~2.18.0~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}