###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for samba MDKA-2007:001 (samba)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830202);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:001");
  script_cve_id("");
  script_name( "Mandriva Update for samba MDKA-2007:001 (samba)");
  desc = "

  Vulnerability Insight:

  A number of minor issues were present in the samba packages shipped
  with Mandriva 2007.0. For users with filesystem quotas, samba would not
  indicate the remaining quota as the free disk space (as intended).
  Problems with storing accounts with upper-case usernames in the
  smbpasswd passdb backend (tdbsam and ldapsam were not affected). Errors
  in the pam.d file used in samba for pam 0.9x prevented pam
  authentication (SWAT, and authentication to samba when using &quot;obey pam
  restrictions = yes&quot;). Users were being denied access to shares which
  have a &quot;valid users&quot; statement including a group the user is a member
  of.
  
  These issues have all been fixed in the updated packages. Note that
  some of these fixes were only available in a new upstream version of
  samba, which also changes some behaviour. Please consult the release
  http://www.samba.org/samba/history/samba-3.0.23d.html
  upgrading. Specifically, note the &quot;RID Algorithms &amp; Passdb&quot; if you use
  samba as a file server in a domain context.

  Affected Software/OS:
  samba on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00002.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of samba");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-devel", rpm:"libsmbclient0-devel~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-static-devel", rpm:"libsmbclient0-static-devel~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mount-cifs", rpm:"mount-cifs~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss_wins", rpm:"nss_wins~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-server", rpm:"samba-server~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-smbldap-tools", rpm:"samba-smbldap-tools~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan-clamav", rpm:"samba-vscan-clamav~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan-icap", rpm:"samba-vscan-icap~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0", rpm:"lib64smbclient0~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-devel", rpm:"lib64smbclient0-devel~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-static-devel", rpm:"lib64smbclient0-static-devel~3.0.23d~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}