###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_maildrop_detect.nasl 7136 2010-02-08 12:20:36Z feb $
#
# Maildrop Version Detection
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800291);
  script_version("$Revision: 6681 $: 1.0");
  script_name("Maildrop Version Detection");
  desc = "
  Overview: This script finds the installed Maildrop version and saves
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of Maildrop in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

mailName = find_bin(prog_name:"maildrop", sock:sock);
foreach binary_mailName (mailName)
{
  mailVer = get_bin_version(full_prog_name:chomp(binary_mailName),
                            version_argv:"-version",
                            ver_pattern:"maildrop ([0-9.]+)", sock:sock);
  if(mailVer[1]){
    set_kb_item(name:"Maildrop/Linux/Ver", value:mailVer[1]);
  }
}
ssh_close_connection();
