###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_livezilla_detect.nasl 6463 2010-01-11 16:25:36Z jan $
#
# LiveZilla Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800417);
  script_version("$Revision: 6399 $: 1.0");
  script_name("LiveZilla Version Detection");
  desc = "
  Overview: This script finds the running LiveZilla version and saves
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of LiveZilla in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

lzillaPort = get_http_port(default:80);
if(!lzillaPort){
  exit(0);
}

foreach path (make_list("/", "/LiveZilla", "livezilla", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:lzillaPort);
  rcvRes = http_send_recv(port:lzillaPort, data:sndReq);

  if("LiveZilla GmbH" >< rcvRes)
  {
    lzillaVer = eregmatch(pattern:">[Vv]ersion ([0-9.]+)", string:rcvRes);
    if(lzillaVer[1] != NULL)
    {
      set_kb_item(name:"www/" + lzillaPort + "/LiveZilla",
                 value:lzillaVer[1] + " under " + path);
    }
  }
}
