###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_libtiff_buf_vuln.nasl 3225 2009-07-04 15:12:39Z jul $
#
# LibTIFF TIFF Image Buffer Underflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com> 
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800646);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2285");
  script_bugtraq_id(35451);
  script_name("LibTIFF TIFF Image Buffer Underflow Vulnerability");
  desc = "

  Overview: This host is installed with LibTIFF and is prone to buffer
  underflow vulnerability.

  Vulnerability Insight:
  The flaw is due to buffer underflow error in the 'LZWDecodeCompat()'
  [libtiff/tif_lzw.c] function when processing malicious TIFF images.
 
  Impact:
  A remote attacker could exploit this issue to execute arbitrary code
  or to crash the affected application.

  Impact level: System/Application

  Affected Software/OS:
  LibTIFF versions 3.x
  
  Fix: Apply the patches available.
  http://bugzilla.maptools.org/attachment.cgi?id=314


  References:
  http://secunia.com/advisories/35515/
  https://bugs.edge.launchpad.net/bugs/380149
  http://www.lan.st/showthread.php?t=1856&page=3
  http://www.vupen.com/english/advisories/2009/1637

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N) 
    CVSS Temporal Score  : 3.5 
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of LibTIFF");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

libtiffPaths = find_file(file_name:"config.status", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);

foreach libtiffBin (libtiffPaths)
{
  libtiffVer = get_bin_version(full_prog_name:chomp(libtiffBin), sock:sock,
          version_argv:"--version", ver_pattern:"config.status ([0-9.]+)");

  if(("LibTIFF" >< libtiffVer) && (libtiffVer[1] != NULL))
  {
    if(version_in_range(version:libtiffVer[1], test_version:"3.0",
                                          test_version2:"3.8.2")){
      security_warning(0);
      exit(0);
    }
  }
}
