###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kerio_mailserver_xss_vuln_aug09.nasl 2009-08-07 11:54:58Z aug $
#
# Kerio MailServer WebMail 'Integration' Page XSS Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800675);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2636");
  script_bugtraq_id(35264);
  script_name("Kerio MailServer WebMail 'Integration' Page XSS Vulnerability");
  desc = "

  Overview: The host is running Kerio MailServer and is prone to Cross-Site
  Scripting vulnerability

  Vulnerability Insight:
  Issue is due to certain unspecified input passed to the integration page of
  the WebMail component which is not properly sanitised before being returned
  to the user.

  Impact:
  Successful exploitation could result in insertion of arbitrary HTML and script
  code in the user's browser session in the context of an affected site.

  Impact Level: Application

  Affected Software/OS:
  Kerio MailServer version 6.6.0 before 6.6.2 Patch 3 and
                           6.7.0 before 6.7.0 Patch 1

  Fix: Upgrade to Kerio MailServer 6.6.2 Patch 3 or 6.7.0 Patch 1 or later
  http://www.kerio.com/kms_download.html

  References:
  http://secunia.com/advisories/35392
  http://www.kerio.com/support/security-advisories#0906
  http://securitytracker.com/alerts/2009/Jun/1022348.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Kerio MailServer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_kerio_mailserver_detect.nasl");
  script_require_keys("KerioMailServer/Ver");
  exit(0);
}


include("version_func.inc");

kerioVer = get_kb_item("KerioMailServer/Ver");
if(!kerioVer){
  exit(0);
}

# Check for 6.6.x
if(kerioVer =~ "^6\.6")
{
  # Grep for Kerio MailServer veriosn < 6.6.2.patch3
  if(version_is_less(version:kerioVer, test_version:"6.6.2.patch3")){
    security_warning(0);
  }
}
# Check for 6.7.x
else if(kerioVer =~ "^6\.7")
{
  # Grep for Kerio MailServer veriosn < 6.7.0.patch1
  if(version_is_less(version:kerioVer, test_version:"6.7.0.patch1")){
    security_warning(0);
  }
}
