###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kaspersky_prdts_sec_bypass_vuln_aug09.nasl 3741 2009-08-03 17:42:29Z Aug $
#
# Kaspersky AntiVirus and Internet Security Unspecified Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800850);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2647");
  script_bugtraq_id(35789);
  script_name("Kaspersky AntiVirus and Internet Security Unspecified Vulnerability");
  desc = "

  Overview: This host is installed with Kaspersky AntiVirus or Internet Security
  and is prone to an unspecified vulnerability.

  Vulnerability Insight:
  Issue is caused by an unspecified error which could allow an external script
  to disable the computer protection, facilitating further attacks.

  Impact:
  Successful attacks lets the attacker to bypass security restrictions.

  Impact Level: Application

  Affected Software/OS:
  Kaspersky Anti-Virus/Internet Security 2010 version prior to 9.0.0.463

  Fix: Upgrade to Critical Fix 1 (version 9.0.0.463)
  http://www.kaspersky.com/technews?id=203038755

  References:
  http://secunia.com/advisories/35978
  http://xforce.iss.net/xforce/xfdb/51986
  http://www.vupen.com/english/advisories/2009/1998

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Kaspersky AV/Internet Security");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_kaspersky_av_detect.nasl");
  script_require_keys("Kaspersky/AV/Ver", "Kaspersky/IntNetSec/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

# For Kaspersky AntiVirus
kavVer = get_kb_item("Kaspersky/AV/Ver");
if(kavVer != NULL)
{
  # Grep for Kaspersky AntiVirus 2010 version 9.0 < 9.0.0.463
  if(version_in_range(version:kavVer, test_version:"9.0",
                                      test_version2:"9.0.0.462"))
  {
    security_warning(0);
    exit(0);
  }
}

# For Kaspersky Internet Security
kisVer = get_kb_item("Kaspersky/IntNetSec/Ver");
if(kisVer != NULL)
{
  # Grep for Kaspersky Inetnet Security 2010 version 9.0 < 9.0.0.463
  if(version_in_range(version:kisVer, test_version:"9.0",
                                      test_version2:"9.0.0.462")){
    security_warning(0);
  }
}
