###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_jpgraph_detect.nasl 6417 2010-01-12 16:25:36Z jan $
#
# JpGraph Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
#This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800413);
  script_version("$Revision: 6399 $:1.0");
  script_name("JpGraph Version Detection");
  desc = "
  Overview: This script finds the running JpGraph version and saves
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of JpGraph in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

jgphPort = get_http_port(default:80);
if(!jgphPort){
  exit(0);
}

foreach path (make_list("/", "/jpgraph", "/jpgraph/docportal", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.html"), port:jgphPort);
  rcvRes = http_send_recv(port:jgphPort, data:sndReq);
  if("JpGraph" >< rcvRes)
  {
    sndReq = http_get(item:string(path, "/../VERSION"), port:jgphPort);
    rcvRes = http_keepalive_send_recv(port:jgphPort, data:sndReq, bodyonly:1);
    if(!isnull(rcvRes))
    {
      jgphVer = eregmatch(pattern:"v([0-9.]+)",string:rcvRes);
      if(jgphVer[1] != NULL)
      {
        set_kb_item(name:"www/" + jgphPort + "/JpGraph",
                    value:jgphVer[1] + " under " + path);
      }
    }
  }
}
