###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ikiwiki_teximg_info_disclosure_vuln.nasl 4418 2009-09-02 22:25:17Z sep $
#
# ikiwiki Teximg Plugin TeX Command Arbitrary File Disclosure Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800689);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2944");
  script_bugtraq_id(36181);
  script_name("ikiwiki Teximg Plugin TeX Command Arbitrary File Disclosure Vulnerability");
  desc = "
  Overview: This host has ikiwiki installed and is prone to Information Disclosure
  Vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to error in 'teximg' plugin. It incorrectly
  allows the usage of unsafe TeX commands.

  Impact:
  Successful exploitation will let the remote attacker to disclose the content
  of arbitrary local files.

  Impact Level: Application

  Affected Software/OS:
  ikiwiki versions 2.x through 2.53.3 and 3.x through 3.1415925

  Fix: Upgrade to ikiwiki version 3.1415926 or 2.53.4
  http://ikiwiki.info/download/

  References:
  http://secunia.com/advisories/36516
  http://ikiwiki.info/security/#index35h2
  http://www.vupen.com/english/advisories/2009/2475

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of ikiwiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_ikiwiki_detect.nasl");
  script_require_keys("ikiwiki/Ver");
  exit(0);
}


include("version_func.inc");

ikiwikiVer = get_kb_item("ikiwiki/Ver");
if(ikiwikiVer != NULL)
{
  if(version_in_range(version:ikiwikiVer, test_version:"2.0", test_version2:"2.53.3")||
     version_in_range(version:ikiwikiVer, test_version:"3.0", test_version2:"3.1415925")){
      security_warning(0);
  }
}
