###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for HP-UX Pkg HPSBUX02464
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835209);
  script_version("$Revision: 6682 $: 1.0");
  script_xref(name: "HPSBUX", value: "02464");
  script_cve_id("CVE-2009-4184");
  script_name("HP-UX Update for HP-UX Pkg HPSBUX02464");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified on HP Enterprise 
  Cluster Master Toolkit (ECMT) version B.05.00 running on HP-UX. This 
  vulnerability could be exploited by local users to gain unauthorized access. 

  Impact:
  Local unauthorized access

  Affected Software/OS:
  HP-UX Pkg on
  ECMT B.05.00 running on HP-UX B.11.23 (11i v2) or HP-UX B.11.31 (11i v3). 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01894850

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of HP-UX Pkg");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"SG-Oracle-Tool.CM-ORACLE", patch_list:['PHSS_40230'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SG-Sybase-Tool.CM-SYBASE", patch_list:['PHSS_40230'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"SG-Oracle-Tool.CM-ORACLE", patch_list:['PHSS_40229'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SG-Sybase-Tool.CM-SYBASE", patch_list:['PHSS_40229'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
