###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for NFS/ONCplus HPSBUX02440
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835201);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02440");
  script_cve_id("CVE-2009-1421");
  script_name("HP-UX Update for NFS/ONCplus HPSBUX02440");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with NFS/ONCplus 
  running on HP-UX. The vulnerability could be exploited locally to create a 
  Denial of Service (DoS) 

  Impact:
  Remote Denial of Service (DoS)

  Affected Software/OS:
  NFS/ONCplus on
  HP-UX B.11.31 running NFS / ONCplus version B.11.31_07 and B.11.31_06 only 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01793493-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of NFS/ONCplus");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64ALIB", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CLIENT", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CORE", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-KRN", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-PRG", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SERVER", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CLIENT", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CORE", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-PRG", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-SERVER", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CLIENT", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CORE", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-SERVER", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CLIENT", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CORE", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-SERVER", revision:"B.11.31.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}