###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Netscape Directory Server (NDS) HPSBUX02324
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835174);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02324");
  script_cve_id("CVE-2008-0892");
  script_name( "HP-UX Update for Netscape Directory Server (NDS) HPSBUX02324");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  Netscape Directory Server (NDS). The vulnerability could be used locally to 
  gain extended privileges. 

  Impact:
  Local gain extended privileges.

  Affected Software/OS:
  Netscape Directory Server (NDS) on
  HP-UX B.11.11, B.11.23, and B.11.31 running Netscape Directory Server (NDS) 
  vB.06.21.40 or earlier and vB.07.10.40 or earlier. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01433676-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Netscape Directory Server (NDS)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-ADM", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BASE", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BSCLNT", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BSJRE", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-NC", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-NSPERL", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-PERLDAP", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-RUN", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SLAPD", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SLCLNT", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SVCORE", revision:"B.07.10.40", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-ADM", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BASE", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BSCLNT", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BSJRE", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-NC", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-NSPERL", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-PERLDAP", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-RUN", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SLAPD", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SLCLNT", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SVCORE", revision:"B.06.21.60", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-ADM", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BASE", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BSCLNT", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BSJRE", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-NC", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-NSPERL", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-PERLDAP", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-RUN", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SLAPD", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SLCLNT", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SVCORE", revision:"B.07.10.40", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-ADM", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BASE", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BSCLNT", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BSJRE", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-NC", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-NSPERL", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-PERLDAP", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-RUN", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SLAPD", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SLCLNT", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SVCORE", revision:"B.06.21.60", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-ADM", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BASE", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BSCLNT", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-BSJRE", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-NC", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-NSPERL", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-PERLDAP", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-RUN", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SLAPD", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SLCLNT", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr7.NDS-SVCORE", revision:"B.07.10.40", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-ADM", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BASE", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BSCLNT", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-BSJRE", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-NC", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-NSPERL", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-PERLDAP", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-RUN", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SLAPD", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SLCLNT", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NetscapeDirSvr6.NDS-SVCORE", revision:"B.06.21.60", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}