###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Software Distributor (SD) HPSBUX02195
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835145);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02195");
  script_cve_id("CVE-2006-4334", "CVE-2006-4335", "CVE-2006-4336", "CVE-2006-4337", "CVE-2006-4338");
  script_name( "HP-UX Update for Software Distributor (SD) HPSBUX02195");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with the version of 
  GZIP delivered by HP-UX Software Distributor (SD). The vulnerability could 
  be remotely exploited leading to a Denial of Service (DoS). 

  Impact:
  Remote Denial of Service (DoS)

  Affected Software/OS:
  Software Distributor (SD) on
  HP-UX B.11.11 and B.11.23 running Software Distributor (SD) 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00874667-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Software Distributor (SD)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"SW-DIST.GZIP", revision:"B.11.23.0612", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-AGENT", revision:"B.11.23.0612", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-CMDS", revision:"B.11.23.0612", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"SW-DIST.GZIP", patch_list:['PHCO_35587'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-AGENT", patch_list:['PHCO_35587'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SW-DIST.SD-CMDS", patch_list:['PHCO_35587'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}