###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for rpc.mountd HPSBUX00272
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835113);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00272");
  script_cve_id("CAN-1999-1225");
  script_name( "HP-UX Update for rpc.mountd HPSBUX00272");
  desc = "

  Vulnerability Insight:
  A security vulnerability has been identified on HP-UX where error messages 
  returned by rpc.mountd can potentially be used togain remote unauthorzied 
  access. 

  Impact:
  Remote unauthorized access.

  Affected Software/OS:
  rpc.mountd on
  HP-UX B.11.00, B.11.11, and B.11.22. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00908660-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of rpc.mountd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-KRN", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CLIENT", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-PRG", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CORE", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NISPLUS-CORE", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SERVER", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CORE", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CLIENT", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-SERVER", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-INETD", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64ALIB", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"NFS.NFS-PRG", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-SERVER", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-KRN", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CLIENT", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CORE", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-SERVER", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CLIENT", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CORE", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-SERVER", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NISPLUS2-CORE", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64ALIB", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CLIENT", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CORE", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-PRG", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SERVER", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-SERVER", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NISPLUS-CORE", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-KRN", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}