###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for X Font Server (xfs) Software HPSBUX00228
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835159);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00228");
  script_cve_id("");
  script_name( "HP-UX Update for X Font Server (xfs) Software HPSBUX00228");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX running X 
  Font Server (xfs) software, where a buffer overflowmay allow a remote user 
  to obtain unauthorized access or cause a Denial of Service (DoS). 

  Impact:
  Remote unauthorized access or Denial of Service (DoS).

  Affected Software/OS:
  X Font Server (xfs) Software on
  HP-UX B.10.10, B.10.20, B.10.24, B.11.00, B.11.04, B.11.11 and B.11.22 on HP 
  9000 Series 700 and 800 running X Font Server (xfs) software. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00965492-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of X Font Server (xfs) Software");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"X Font Server (xfs)", patch_list:['PHSS_28469'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.24")
{

  if(ishpuxpkgvuln(pkg:"X Font Server (xfs)", revision:"10.20", rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"X Font Server (xfs)", revision:"11.00", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"X Font Server (xfs)", patch_list:['PHSS_28468'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"X Font Server (xfs)", patch_list:['PHSS_28471'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"X Font Server (xfs)", patch_list:['PHSS_28470'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}