###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for JAVA Web Start HPSBUX00188
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835048);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00188");
  script_cve_id("");
  script_name( "HP-UX Update for JAVA Web Start HPSBUX00188");
  desc = "

  Vulnerability Insight:
  A vulnerability in Java(TM) Web Start may allow an applicationremote 
  unauthorized access. 

  Impact:
  Remote unauthorized access.

  Affected Software/OS:
  JAVA Web Start on
  HP-UX B.11.XX running Java Web Start. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01035756-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of JAVA Web Start");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"webstart_10101", revision:"1.0.1.01", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"webstart_10101", revision:"1.0.1.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"webstart_10101", revision:"1.0.1.01", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"webstart_10101", revision:"1.0.1.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}