###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for rlpdaemon HPSBUX00163
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835147);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00163");
  script_cve_id("CAN-2001-0668");
  script_name( "HP-UX Update for rlpdaemon HPSBUX00163");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  login(1). The vulnerability could be exploitedremotely to gain unauthorized 
  access or increased privilege. 

  Impact:
  Remote unauthorized access
  increased privilege.

  Affected Software/OS:
  rlpdaemon on
  HP-UX release B.10.01, B.10.10, B.10.20, B.11.00, B.11.11, and B.11.20. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00994294-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of rlpdaemon");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX10.01")
{

  if(ishpuxpkgvuln(pkg:"PrinterMgmt.LP-SPOOL", patch_list:['PHCO_24697'], rls:"HPUX10.01"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.10")
{

  if(ishpuxpkgvuln(pkg:"PrinterMgmt.LP-SPOOL", patch_list:['PHCO_24698'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"PrinterMgmt.LP-SPOOL", patch_list:['PHCO_24700'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"PrinterMgmt.LP-SPOOL", patch_list:['PHCO_24699'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.20")
{

  if(ishpuxpkgvuln(pkg:"PrinterMgmt.LP-SPOOL", patch_list:['PHCO_24868'], rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"PrinterMgmt.LP-SPOOL", patch_list:['PHCO_24701'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
